import { IParam } from "@core";
import { MDView } from "../md-view";
import { DataViewProps } from "./data-view-prop";
import { DataViewState } from "./data-view-state";

/**
 * 实体数据视图
 *
 * @export
 * @class DataView
 * @extends {MDView}
 */
export class DataView extends MDView {

  /**
   * 实体数据视图状态
   *
   * @type {DataViewState}
   * @memberof DataView
   */
  public declare state: DataViewState;

  /**
   * 实体数据视图输入参数
   *
   * @type {DataViewProps}
   * @memberof DataView
   */
  public declare props: DataViewProps;

  /**
   * @description 列表部件
   * @type {IParam}
   * @memberof DataView
   */
  public declare dataViewControl: IParam;

  /**
   * @description 处理视图初始化
   * @memberof DataView
   */
  public useViewInit(): void {
    super.useViewInit();
    this.dataViewControl = ref(null);
  }

  /**
   * @description 获取多数据部件
   * @return {*} 
   * @memberof DataView
   */
  public getMDCtrl() {
    return unref(this.dataViewControl);
  }

  /**
   * @description 安装视图所有功能模块的方法
   * @return {*} 
   * @memberof DataView
   */
  public moduleInstall() {
    const superParams = super.moduleInstall();
    return {
      ...superParams,
      dataViewControl: this.dataViewControl
    };
  }
}